<?xml version="1.0" encoding="ISO-8859-1"?> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >


<xsl:template match="*" mode="input" >
	<xsl:param name="type" select="'text'" />   
	<xsl:param name="style" select="'width=100%'" />   
	<xsl:param name="maxlength" />   
	<xsl:param name="readonly" select="0" />   
	<xsl:param name="name" />   
	<xsl:param name="vUniqueID" />   
	<xsl:param name="tabindex" />   
	<xsl:param name="handlerKeyUp" />   
	<xsl:param name="handlerClick" />   
	<xsl:param name="handlerChange" />   

	<xsl:element name="input"> 
		<xsl:attribute name="type"><xsl:value-of select="$type"/></xsl:attribute>	
		<xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute>	 
		<xsl:attribute name="maxlength"><xsl:value-of select="$maxlength"/></xsl:attribute>	 
		<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>					

		<xsl:if test="not($tabindex='')" >		
			<xsl:attribute name="tabindex"><xsl:value-of select="$tabindex"/></xsl:attribute>							 
		</xsl:if>

		<xsl:if test="$name=''" >				
			<xsl:attribute name="name"><xsl:value-of select="@UniqueInternalID"/></xsl:attribute>	
		</xsl:if>
		<xsl:if test="not($name='')" >				
			<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>	
		</xsl:if>

		<xsl:if test="not($handlerKeyUp='')" >		
			<xsl:attribute name="onKeyUp"><xsl:value-of select="$handlerKeyUp"/></xsl:attribute>							 
		</xsl:if>
		<xsl:if test="not($handlerClick='')" >		
			<xsl:attribute name="onclick"><xsl:value-of select="$handlerClick"/></xsl:attribute>							 
		</xsl:if>
		<xsl:if test="not($handlerChange='')" >		
			<xsl:attribute name="onChange"><xsl:value-of select="$handlerChange"/></xsl:attribute>							 
		</xsl:if>

		<xsl:if test="$readonly='1'">
        	<xsl:attribute name="readonly"><xsl:value-of select="$readonly"/></xsl:attribute>	
		</xsl:if>          				
		
		<xsl:if test="$type='checkbox'">
 			<xsl:variable name="checked"><xsl:value-of select="."/></xsl:variable>
 			<xsl:if test="$checked='1'"> 
				<xsl:attribute name="checked">1</xsl:attribute>					
 			</xsl:if>				
		</xsl:if>
	</xsl:element>					

	<xsl:if test="not($vUniqueID='')" >		
		<xsl:element name="script" > 
		  <xsl:attribute name="type">text/javascript</xsl:attribute>	
		  <xsl:comment>
		  &#160; 
		  var <xsl:value-of select="$vUniqueID"/> = "<xsl:value-of select='@UniqueInternalID'/>";
		  //
		  </xsl:comment>
		</xsl:element>					  
	</xsl:if>
</xsl:template>



<xsl:template match="*" mode="input_table" >
	<xsl:param name="label" />   
	<xsl:param name="type" select="'text'" />   
	<xsl:param name="style" select="'width=100%'"/>   
	<xsl:param name="maxlength" />   
	<xsl:param name="readonly" select="0" />   
	<xsl:param name="name" />   
	<xsl:param name="vUniqueID" />   
	<xsl:param name="tabindex" />   
	<xsl:param name="handlerKeyUp" />   
	<xsl:param name="handlerClick" />   
	<xsl:param name="handlerChange" />   
	<xsl:param name="reverse" select="0" />   

	<xsl:if test="$label">
		<xsl:if test="$reverse='0'">
	    	<td><xsl:copy-of select="$label"/></td>   
		</xsl:if>          
	</xsl:if>			  

	<td>
	<xsl:element name="input"> 
		<xsl:attribute name="type"><xsl:value-of select="$type"/></xsl:attribute>	
		<xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute>	 
		<xsl:attribute name="maxlength"><xsl:value-of select="$maxlength"/></xsl:attribute>	 
		<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>					

		<xsl:if test="not($tabindex='')" >		
			<xsl:attribute name="tabindex"><xsl:value-of select="$tabindex"/></xsl:attribute>							 
		</xsl:if>
	
		<xsl:if test="$name=''" >				
			<xsl:attribute name="name"><xsl:value-of select="@UniqueInternalID"/></xsl:attribute>	
		</xsl:if>
		<xsl:if test="not($name='')" >				
			<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>	
		</xsl:if>
	
		<xsl:if test="not($handlerKeyUp='')" >		
			<xsl:attribute name="onKeyUp"><xsl:value-of select="$handlerKeyUp"/></xsl:attribute>							 
		</xsl:if>
	
		<xsl:if test="not($handlerClick='')" >		
			<xsl:attribute name="onclick"><xsl:value-of select="$handlerClick"/></xsl:attribute>							 
		</xsl:if>
		<xsl:if test="not($handlerChange='')" >		
			<xsl:attribute name="onChange"><xsl:value-of select="$handlerChange"/></xsl:attribute>							 
		</xsl:if>
	
		<xsl:if test="$readonly='1'">
	    	<xsl:attribute name="readonly"><xsl:value-of select="$readonly"/></xsl:attribute>	
		</xsl:if>          								
	
		<xsl:if test="$type='checkbox'">
	 		<xsl:variable name="checked"><xsl:value-of select="."/></xsl:variable>
 			<xsl:if test="$checked='1'"> 
				<xsl:attribute name="checked">1</xsl:attribute>					
 			</xsl:if>				
		</xsl:if>
	</xsl:element>					
	</td>
	
	<xsl:if test="$reverse='1'">
		<td><xsl:copy-of select="$label"/></td>
	</xsl:if>          	

	<xsl:if test="not($vUniqueID='')" >		
		<xsl:element name="script" > 
			<xsl:attribute name="type">text/javascript</xsl:attribute>	
			<xsl:comment>
			&#160; 
			var <xsl:value-of select="$vUniqueID"/> = "<xsl:value-of select='@UniqueInternalID'/>";
			//
			</xsl:comment>
		</xsl:element>					  
	</xsl:if>	
</xsl:template>



<xsl:template match="*" mode="textarea" >
	<xsl:param name="style" />   
	<xsl:param name="cols" />   
	<xsl:param name="rows" />   

	<xsl:element name="textarea"> 
		<xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute>	 
		<xsl:attribute name="name"><xsl:value-of select="@UniqueInternalID"/></xsl:attribute>	
		<xsl:attribute name="cols"><xsl:value-of select="$cols"/></xsl:attribute>	
		<xsl:attribute name="rows"><xsl:value-of select="$rows"/></xsl:attribute>	
		<xsl:value-of select="."/>
	</xsl:element>					
</xsl:template>



<xsl:template match="*" mode="textarea_table" >
	<xsl:param name="label" />   
	<xsl:param name="style" />   
	<xsl:param name="cols" />   
	<xsl:param name="rows" />   

	<xsl:if test="$label">
		<td><xsl:value-of select="$label"/></td>   
	</xsl:if>			  
	<td> 
	<xsl:element name="textarea"> 
		<xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute>	 
		<xsl:attribute name="name"><xsl:value-of select="@UniqueInternalID"/></xsl:attribute>	
		<xsl:attribute name="cols"><xsl:value-of select="$cols"/></xsl:attribute>	
		<xsl:attribute name="rows"><xsl:value-of select="$rows"/></xsl:attribute>	
		<xsl:value-of select="."/>
	</xsl:element>					
	</td> 
</xsl:template>



<xsl:template match="*" mode="combo" >
	<xsl:param name="style" />   
	<xsl:param name="size" />   
	<xsl:param name="multiple" />   
	<xsl:param name="vUniqueID" />   
	<xsl:param name="list" />   
	<xsl:param name="valueList" />   
	<xsl:param name="handlerChange" />   
	<xsl:param name="handlerFocus" />   
	<xsl:param name="handlerKeyDown" />   
	<xsl:param name="handlerMouseDown" />   

	<xsl:element name="select" > 
		<xsl:attribute name="name"><xsl:value-of select="@UniqueInternalID"/></xsl:attribute>	
		<xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute>	 

		<xsl:if test="not($size='')" >		
			<xsl:attribute name="size"><xsl:value-of select="$size"/></xsl:attribute>							 
		</xsl:if>
		<xsl:if test="not($multiple='')" >		
			<xsl:attribute name="multiple">1</xsl:attribute>							 
		</xsl:if>

		<xsl:if test="not($handlerChange='')" >		
			<xsl:attribute name="onChange"><xsl:value-of select="$handlerChange"/></xsl:attribute>							 
		</xsl:if>
		<xsl:if test="not($handlerFocus='')" >		
			<xsl:attribute name="onfocus"><xsl:value-of select="$handlerFocus"/></xsl:attribute>							 
		</xsl:if>
		<xsl:if test="not($handlerKeyDown='')" >		
			<xsl:attribute name="onKeyDown"><xsl:value-of select="$handlerKeyDown"/></xsl:attribute>							 
		</xsl:if>
		<xsl:if test="not($handlerMouseDown='')" >		
			<xsl:attribute name="onMouseDown"><xsl:value-of select="$handlerMouseDown"/></xsl:attribute>							 
		</xsl:if>
	</xsl:element > 	

	<xsl:element name="script" > 
		<xsl:attribute name="type">text/javascript</xsl:attribute>	
		<xsl:comment>
		&#160;
	  	var <xsl:value-of select="$vUniqueID"/> = "<xsl:value-of select='@UniqueInternalID'/>";
 		clearSelect(<xsl:value-of select="$vUniqueID"/>);
		fillSelectFromList2(<xsl:value-of select="$vUniqueID"/>, <xsl:value-of select='$list'/>, <xsl:value-of select='$valueList'/>, "<xsl:value-of select='.'/>");
		//
		</xsl:comment>
	</xsl:element>					  
</xsl:template>



<xsl:template match="*" mode="combo_table" >
	<xsl:param name="label" />   
	<xsl:param name="style" />   
	<xsl:param name="size" />   
	<xsl:param name="multiple" />   
	<xsl:param name="vUniqueID" />   
	<xsl:param name="list" />   
	<xsl:param name="valueList" />   
	<xsl:param name="handlerChange" />   
	<xsl:param name="handlerFocus" />   
	<xsl:param name="handlerKeyDown" />   
	<xsl:param name="handlerMouseDown" />   

	<xsl:if test="$label">
		<td><xsl:copy-of select="$label"/></td>   
	</xsl:if>			  
	
	<td>
	<xsl:element name="select" > 
		<xsl:attribute name="name"><xsl:value-of select="@UniqueInternalID"/></xsl:attribute>	
		<xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute>	 

		<xsl:if test="not($size='')" >		
			<xsl:attribute name="size"><xsl:value-of select="$size"/></xsl:attribute>							 
		</xsl:if>
		<xsl:if test="not($multiple='')" >		
			<xsl:attribute name="multiple">1</xsl:attribute>							 
		</xsl:if>

		<xsl:if test="not($handlerChange='')" >		
			<xsl:attribute name="onChange"><xsl:value-of select="$handlerChange"/></xsl:attribute>							 
		</xsl:if>
		<xsl:if test="not($handlerFocus='')" >		
			<xsl:attribute name="onfocus"><xsl:value-of select="$handlerFocus"/></xsl:attribute>							 
		</xsl:if>
		<xsl:if test="not($handlerKeyDown='')" >		
			<xsl:attribute name="onKeyDown"><xsl:value-of select="$handlerKeyDown"/></xsl:attribute>							 
		</xsl:if>
		<xsl:if test="not($handlerMouseDown='')" >		
			<xsl:attribute name="onMouseDown"><xsl:value-of select="$handlerMouseDown"/></xsl:attribute>							 
		</xsl:if>
	</xsl:element > 	
	</td>	

	<xsl:element name="script" > 
		<xsl:attribute name="type">text/javascript</xsl:attribute>	
		<xsl:comment>
		&#160;
	  	var <xsl:value-of select="$vUniqueID"/> = "<xsl:value-of select='@UniqueInternalID'/>";
	  	clearSelect(<xsl:value-of select="$vUniqueID"/>);
	  	fillSelectFromList2(<xsl:value-of select="$vUniqueID"/>, <xsl:value-of select='$list'/>, <xsl:value-of select='$valueList'/>, "<xsl:value-of select='.'/>");
		//
		</xsl:comment>
	</xsl:element>					  
</xsl:template>




<xsl:template match="*" mode="customcombo" >
	<xsl:param name="id" />   
	<xsl:param name="style" />   
	<xsl:param name="width" select="'100%'" />   
	<xsl:param name="comboVar" />   
	<xsl:param name="list" />   
	<xsl:param name="valueList" />   
	<xsl:param name="handlerKeyUp" />   
	<xsl:param name="form" />   

	<xsl:element name="object" > 
	  <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>	
	  <xsl:attribute name="classid">clsid:73A39A9C-1DBC-4D5A-9972-834D2703892D</xsl:attribute> 				<!-- C++ -->
	  <xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>		
	  <xsl:attribute name="style">padding-bottom:0px; padding-top:0px; margin-bottom:0px; margin-top:0px; </xsl:attribute>		
	</xsl:element>
				
	<xsl:element name="input" > 	
	  <xsl:attribute name="name"><xsl:value-of select="@UniqueInternalID"/></xsl:attribute>	
	  <xsl:attribute name="style">position:absolute; width='0px'; </xsl:attribute>	 
	  <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>					
	  <xsl:attribute name="tabindex">-1</xsl:attribute>					

	  <xsl:attribute name="onKeyUp">
	    <xsl:value-of select="$form"/>.<xsl:value-of select="$id"/>.ComboText = <xsl:value-of select="$form"/>[<xsl:value-of select="$comboVar"/>].value;
	  </xsl:attribute>							 
	</xsl:element>
	
	<xsl:element name="script" > 
	  <xsl:attribute name="type">text/javascript</xsl:attribute>	
	  <xsl:comment>
	  	&#160;var <xsl:value-of select="$comboVar"/> = "<xsl:value-of select='@UniqueInternalID'/>";
	  //
	  </xsl:comment>
	</xsl:element>					  

	<xsl:element name="script" > 
		<xsl:attribute name="type">text/javascript</xsl:attribute>	
		<xsl:attribute name="for"><xsl:value-of select="$id" /></xsl:attribute>	
		<xsl:attribute name="event">onChange</xsl:attribute>	
		<xsl:comment>
		&#160;<xsl:value-of select="$id" />_onChange()
		//
		</xsl:comment>
	</xsl:element>					  

	<xsl:element name="script" > 
		<xsl:attribute name="type">text/javascript</xsl:attribute>	
		<xsl:comment>
		&#160;function <xsl:value-of select="$id" />_onChange()
		{
			<xsl:value-of select="$form" />[<xsl:value-of select="$comboVar" />].value = <xsl:value-of select="$form" />.<xsl:value-of select="$id" />.ComboText;
		}
		<xsl:value-of select="$form"/>.<xsl:value-of select="$id"/>.focus();
		<xsl:value-of select="$form"/>.<xsl:value-of select="$id"/>.blur();
		<xsl:value-of select="$form"/>.<xsl:value-of select="$id"/>.Clear();	  	
	  	<xsl:value-of select="$form"/>.<xsl:value-of select="$id"/>.FillFromList("<xsl:value-of select='$list'/>", "<xsl:value-of select='$valueList'/>");		
	    <xsl:value-of select="$form"/>.<xsl:value-of select="$id"/>.ComboText = <xsl:value-of select="$form"/>[<xsl:value-of select="$comboVar"/>].value;	    
		//
		</xsl:comment>
	</xsl:element>					  	
</xsl:template>



<xsl:template match="*" mode="customcombo_table" >
	<xsl:param name="label" />   
	<xsl:param name="id" />   
	<xsl:param name="style" />   
	<xsl:param name="width" />   
	<xsl:param name="comboVar" />   
	<xsl:param name="list" />   
	<xsl:param name="valueList" />   
	<xsl:param name="handlerKeyUp" />   
	<xsl:param name="form" />   

  	<xsl:if test="$label">
  		<td><xsl:value-of select="$label"/></td>   
  	</xsl:if>			  

	<xsl:element name="object" > 
	  <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>	
	  <xsl:attribute name="classid">clsid:026FB5E7-512E-4361-93CA-15B4D70E4CDE</xsl:attribute>	
	  <xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>		
	</xsl:element>

	<td>				
	<xsl:element name="input" > 	
	  <xsl:attribute name="name"><xsl:value-of select="@UniqueInternalID"/></xsl:attribute>	
	  <xsl:attribute name="style">width='0px'</xsl:attribute>	 
	  <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>					
	  <xsl:attribute name="tabindex">-1</xsl:attribute>					

	  <xsl:attribute name="onKeyUp">
	    <xsl:value-of select="$form"/>.<xsl:value-of select="$id"/>.ComboText = <xsl:value-of select="$form"/>[<xsl:value-of select="$comboVar"/>].value;
	  </xsl:attribute>							 
	</xsl:element>
	
	<xsl:element name="script" > 
	  <xsl:attribute name="type">text/javascript</xsl:attribute>	
	  <xsl:comment>
	  	&#160;var <xsl:value-of select="$comboVar"/> = "<xsl:value-of select='@UniqueInternalID'/>";
	  //
	  </xsl:comment>
	</xsl:element>					  
		
	<xsl:element name="script" > 
		<xsl:attribute name="type">text/javascript</xsl:attribute>	
		<xsl:attribute name="for"><xsl:value-of select="$id" /></xsl:attribute>	
		<xsl:attribute name="event">onChange</xsl:attribute>	
		<xsl:comment>
		&#160;<xsl:value-of select="$id" />_onChange()
		//
		</xsl:comment>
	</xsl:element>					  

	<xsl:element name="script" > 
		<xsl:attribute name="type">text/javascript</xsl:attribute>	
		<xsl:comment>
		&#160;function <xsl:value-of select="$id" />_onChange()
		{
			<xsl:value-of select="$form" />[<xsl:value-of select="$comboVar" />].value = <xsl:value-of select="$form" />.<xsl:value-of select="$id" />.ComboText;
		}
		<xsl:value-of select="$form"/>.<xsl:value-of select="$id"/>.Clear();	  	
	  	<xsl:value-of select="$form"/>.<xsl:value-of select="$id"/>.FillFromList("<xsl:value-of select='$list'/>", "<xsl:value-of select='$valueList'/>");		
	    <xsl:value-of select="$form"/>.<xsl:value-of select="$id"/>.ComboText = <xsl:value-of select="$form"/>[<xsl:value-of select="$comboVar"/>].value;	    
		//
		</xsl:comment>
	</xsl:element>					  		
	</td>
</xsl:template>



<xsl:template name="checkboxListElement" >
	<xsl:param name="label" select="(label)"/>   
	<xsl:param name="tag" />   
	<xsl:param name="val"/>   

	<tr>
		<td>&#160;</td>
	
	    <td><xsl:value-of select="$label"/></td>
		<td>
		<xsl:element name="input"> 
			<xsl:attribute name="type">checkbox</xsl:attribute>	
			<xsl:attribute name="name">
			    <xsl:value-of select="@UniqueInternalID"/>_sysXXXX_<xsl:value-of select="$tag"/>
			</xsl:attribute>	 

			<xsl:if test="contains($val, $tag)" >
				<xsl:attribute name="value">1</xsl:attribute>									
				<xsl:attribute name="checked">1</xsl:attribute>													
			</xsl:if>

			<xsl:if test="not(contains($val, $tag))" >
				<xsl:attribute name="value">0</xsl:attribute>									
			</xsl:if>

		</xsl:element>					
		</td>		
	</tr>
</xsl:template>



<xsl:template name="checkboxList" >
     <xsl:param name="labelList" />
     <xsl:param name="tagList" />
     <xsl:param name="val" />
     
     <xsl:variable name="firstLabel" select="substring-before($labelList, ',')" />
     <xsl:variable name="restLabel" select="substring-after($labelList, ',')" />

     <xsl:variable name="firstTag" select="substring-before($tagList, ',')" />
     <xsl:variable name="restTag" select="substring-after($tagList, ',')" />

     <xsl:if test="string-length($firstLabel) > 0" >
	     <xsl:call-template name="checkboxListElement"  >     
	         <xsl:with-param name="label">
		         <xsl:value-of select="$firstLabel" />
	         </xsl:with-param>
	         <xsl:with-param name="tag">
		         <xsl:value-of select="$firstTag" />
	         </xsl:with-param>
	         <xsl:with-param name="val">
		         <xsl:value-of select="$val" />
	         </xsl:with-param>     
	     </xsl:call-template>    	
     </xsl:if>

     <xsl:if test="string-length($firstLabel) = 0" >
	     <xsl:call-template name="checkboxListElement"  >     
	         <xsl:with-param name="label">
		         <xsl:value-of select="$labelList" />
	         </xsl:with-param>
	         <xsl:with-param name="tag">
		         <xsl:value-of select="$tagList" />
	         </xsl:with-param>
	         <xsl:with-param name="val">
		         <xsl:value-of select="$val" />
	         </xsl:with-param>     
	     </xsl:call-template>    	
     </xsl:if>
     
     <xsl:if test="$restLabel" >
         <xsl:call-template name="checkboxList" >
             <xsl:with-param name="labelList" select="$restLabel" />
             <xsl:with-param name="tagList" select="$restTag" />
             <xsl:with-param name="val" select="$val" />
         </xsl:call-template>
     </xsl:if>
</xsl:template>



<xsl:template match="*" mode="plain_text" >
    <xsl:value-of select="."/>
</xsl:template>



<xsl:template name="java_ComboBox" >
			<xsl:element name="script" > 
				<xsl:attribute name="type">text/javascript</xsl:attribute>	
				<xsl:comment>

				var zvsLastKey = 0;
				var zvsLastTime = 0;

				function prelled()
				{
					var prell = 0;
					if(event.keyCode == zvsLastKey)
					{
						var jetzt = new Date();
						var ms = jetzt.getTime();

						var delta = ms - zvsLastTime;
						if(isNaN(delta))
							prell = 1;

						if(delta &lt; 200)
							prell = 1;
					}
					
					zvsLastKey  = event.keyCode;
					zvsLastTime = ms;

					return(prell);
				}

				function clearSelect(ctrlName)
				{
					try
					{
						var selNode = document.getElementsByName(ctrlName)[0];					
						while(selNode.hasChildNodes())
							selNode.removeChild(selNode.firstChild); 
					}
					catch(err)
					{
					}
				}

				function fillSelectFromList3(ctrlName, lblList, valList, selVal, multiSep)
				{
					var selNode   = document.getElementsByName(ctrlName)[0];					

					if(valList.length == 0)
					  valList = lblList;

					var selValues = selVal.split(multiSep);

					for(var k = 0; k &lt; selValues.length; k++)
					{					
						var replaced = true;
						while(replaced)
						{	
							replaced = false;
							var x = selValues[k];					
							var pos1 = x.indexOf('&amp;#');
							if(pos1 != -1)
							{
								var tmp = x.substr(pos1 + 2);
								var pos2 = tmp.indexOf(';');
								if(pos2 != -1)
								{
									var ascii = x.substr(pos1 + 2, pos2);
									var c = String.fromCharCode(parseInt(ascii));
									var r = x.substr(pos1, pos2 + 3);
									<!-- alert(ascii + ' ' + c + ' ' + r);	-->			
									var rExp = new RegExp(r, 'gi');
									var z = x.replace(rExp, c);							
									selValues[k] = z;
									replaced = true;
								}
							}
						}
					}

				    var i = 0;
					while(lblList.length > 0)
					{
						var lbl;
						var val;
						var posL = lblList.indexOf(",");
						var posV = valList.indexOf(",");
						if(posL == -1)
						{
							lbl = lblList; lblList = "";
							val = valList; valList = "";
						}
						else
						{
							lbl = lblList.substr(0,posL); lblList = lblList.substr(posL+1, lblList.length-posL-1);
							val = valList.substr(0,posV); valList = valList.substr(posV+1, valList.length-posV-1);
						}
					
						var option 	= document.createElement("option");

						var vA      = document.createAttribute("value");
						vA.nodeValue = val;
						option.setAttributeNode(vA);

						for(var k = 0; k &lt; selValues.length; k++)
						{
							if(val == selValues[k])
							{
								var sA = document.createAttribute("selected");
								sA.nodeValue = "selected";
								option.setAttributeNode(sA);							
								break;
							}						
						}

						option.appendChild(document.createTextNode(lbl));					
						selNode.appendChild(option);
					}						
				}

				function fillSelectFromList2(ctrlName, lblList, valList, selVal)
				{
					try
					{
						fillSelectFromList3(ctrlName, lblList, valList, selVal, ",");
					}
					catch(err)
					{
					}
				}

				<!-- SELECT with key memory -->

				var selectedOption = 0;
				var KeyPressEnabled = true;
				var keyMemory = "";
				
				function MemoryComboFocus()
				{
					selectedOption = 0;
					keyMemory = "";
				}
				
				function MemoryComboSelectChange(theCombo)
				{
					if(KeyPressEnabled)
						theCombo.selectedIndex = selectedOption;	 
				}
					
				function MemoryComboKeyPress(theCombo)
				{	
					if(prelled() == 1)
						return;
				
					KeyPressEnabled = true;
				
					if(event.keyCode == 38)
					{
						keyMemory = "";
						selectedOption = theCombo.selectedIndex - 1;
						return;
					}	
					
					if(event.keyCode == 40)
					{
						keyMemory = "";
						selectedOption = theCombo.selectedIndex + 1;
						return;
					}
				
					if(event.keyCode == 37 || event.keyCode == 8 || event.keyCode == 46)
					{
						theCombo.selectedIndex = 0;
						selectedOption = 0;
						keyMemory = "";
						return;
					}
				
   				    var umlaut = (event.keyCode == 186 || event.keyCode == 192 || event.keyCode == 222);
					if(event.keyCode != 32)
					{
						if((event.keyCode &lt; 65 || event.keyCode &gt; 90) &amp;&amp; !umlaut)		
						  return;
					}
					
					if(umlaut)
					{
						if(event.keyCode == 186) keyMemory += "";
						if(event.keyCode == 192) keyMemory += "";
						if(event.keyCode == 222) keyMemory += "";						
					}
					else
					{				
						keyMemory += String.fromCharCode(event.keyCode).toLowerCase();
					}

					for(x = 0; x &lt; theCombo.length; x++)
					{
						var OptionText = theCombo.options[x].text;
						var tmpOptionText = "";
				
						if(OptionText.length != 0)
						{
							for(y = 0; y &lt; OptionText.length; y++)
							{
								tmpOptionText += OptionText.charAt(y).toLowerCase();			
								if(tmpOptionText == keyMemory)
								{
									theCombo.selectedIndex = x;
									selectedOption = x;
									return;
								}
							}
						}
					}
					keyMemory = "";
				}
				
				//
				</xsl:comment>
	  		</xsl:element>					  
</xsl:template>

</xsl:stylesheet>
