<?xml version="1.0" encoding="ISO-8859-1"?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="1.0" encoding="ISO-8859-1"/>


<xsl:template match="/">											<!-- ROOT --> 
<html>
	<head>
		<title>generic</title>
		<style type="text/css">
		body { background-color:buttonface; }
		#headline  { position:absolute; top:8px; left:8px; width:100%; height:88px; z-index:1; }
		#main      { position:absolute; top:105px; left:15px; width:100%; height:150px; z-index:2; }
		</style>
	</head>	

  	<body>
	<div>		
		<table cellspacing="0" cellPadding="0" width="100%" border="0" >		
			<xsl:apply-templates select="*" />      
		</table>
	</div>	
  	</body>
</html>
</xsl:template>



<xsl:template match="*" >											<!-- LEVEL 1 (TOP) --> 
	<xsl:if test="*" >
		<xsl:apply-templates />      
	</xsl:if>
</xsl:template>



<xsl:template match="/*/*" >										<!-- LEVEL 2 (ITEM) --> 
	<xsl:if test="not(*)" >											<!-- create LABEL/INPUT line for nodes without childs -->	
	    <tr>          
			<td>&#160;&#160;</td>
			<td><strong><xsl:value-of select="name(.)"/></strong></td>
			<td>
			<xsl:element name="input"> 
				<xsl:attribute name="type">text</xsl:attribute>	
				<xsl:attribute name="style">WIDTH:400px</xsl:attribute>	
				<xsl:attribute name="name"><xsl:value-of select="@UniqueInternalID"/></xsl:attribute>	
				<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>					
			</xsl:element>					
			</td>
	    </tr>                
	</xsl:if>
	
	<xsl:if test="*" >												<!-- create LABEL-only line for nodes with childs -->	
		<tr><td>&#160;</td></tr>
		<tr><td/><td bgColor="#6699ee"><b><xsl:value-of select="name(.)"/></b></td><td bgColor="#6699ee" /></tr>		
		<xsl:apply-templates />		
		<tr><td>&#160;</td></tr>
	</xsl:if>
	
	<xsl:if test="position()=last()">
		<tr><td>&#160;</td></tr>
	</xsl:if>
</xsl:template>



<xsl:template match="/*/*/*" >										<!--- LEVEL 3 (SUBITEM) --> 	
	<xsl:if test="not(*)" >
		<tr>
			<td>&#160;&#160;</td>              
			<td><strong><xsl:value-of select="name(.)"/></strong></td>
			<td>
			<xsl:element name="input"> 
				<xsl:attribute name="type">text</xsl:attribute>	
				<xsl:attribute name="style">WIDTH:400px</xsl:attribute>	
				<xsl:attribute name="name"><xsl:value-of select="@UniqueInternalID"/></xsl:attribute>	
				<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>					
			</xsl:element>					
			</td>
		</tr>        		
	</xsl:if>  
	
	<xsl:if test="*" >
		<tr><td/><td><font color="#4040FF"><b>&#160;&#160;&#160;&#160;<xsl:value-of select="name(.)"/></b></font></td></tr>
		<xsl:apply-templates />
	</xsl:if>
</xsl:template>



<xsl:template match="/*/*/*/*" >									<!--- LEVEL 4 (BOTTOM) --> 
	<xsl:if test="not(*)" >
	    <tr>
			<td>&#160;&#160;</td>			      
			<td> &#160;&#160;&#160; &#160;&#160;&#160;&#160;<xsl:value-of select="name(.)" /></td>
			<td>
			<xsl:element name="input"> 
				<xsl:attribute name="type">text</xsl:attribute>	
				<xsl:attribute name="style">WIDTH:400px</xsl:attribute>	
				<xsl:attribute name="name"><xsl:value-of select="@UniqueInternalID"/></xsl:attribute>	
				<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>					
			</xsl:element>					
			</td>
	    </tr>        
	</xsl:if>  
</xsl:template>



      
</xsl:stylesheet>

