<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">


<xsl:template match="/">										
	<xsl:apply-templates mode="createUniqueID" />
</xsl:template>




<xsl:template match="*" mode="createUniqueID" >
	<xsl:param name="parentID" select="xxx"/>   

	<xsl:variable name="newID">
		<xsl:value-of select="$parentID"/>
		<xsl:if test="$parentID!=''">_sysVV_</xsl:if>
		<xsl:value-of select="name(.)"/>_sysHHH_<xsl:value-of select="position()"/>										
	</xsl:variable>

	<xsl:copy>
		<xsl:apply-templates select="@*" mode="createUniqueID" />		

		<xsl:attribute name="UniqueInternalID">
			<xsl:value-of select="$newID"/>
		</xsl:attribute>

		<xsl:apply-templates mode="createUniqueID" >
			<xsl:with-param name="parentID"><xsl:value-of select="$newID"/></xsl:with-param>				
		</xsl:apply-templates>
	</xsl:copy>
</xsl:template>


<xsl:template match="@*" mode="createUniqueID" >
	<xsl:copy />
</xsl:template>


</xsl:stylesheet>

